/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.container.connected.CloseableWsResponse;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCache;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class PluginReferencesDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginReferencesDownloader.class);
    private final SonarLintWsClient wsClient;
    private final PluginCache pluginCache;

    public PluginReferencesDownloader(SonarLintWsClient wsClient, PluginCache pluginCache) {
        this.wsClient = wsClient;
        this.pluginCache = pluginCache;
    }

    public void fetchPluginsTo(Path dest, Set<String> allowedPlugins) {
        CloseableWsResponse response = this.wsClient.get("deploy/plugins/index.txt");
        Sonarlint.PluginReferences.Builder builder = Sonarlint.PluginReferences.newBuilder();
        String responseStr = response.content();
        Scanner scanner = new Scanner(responseStr);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] fields = StringUtils.split(line, ",");
            String[] nameAndHash = StringUtils.split(fields[fields.length - 1], "|");
            String key = fields[0];
            if (!allowedPlugins.contains(key)) {
                LOG.debug("Plugin {} is not in the SonarLint whitelist. Skip it.", (Object)key);
                continue;
            }
            String filename = nameAndHash[0];
            String hash = nameAndHash[1];
            builder.addReference(Sonarlint.PluginReferences.PluginReference.newBuilder().setKey(key).setHash(hash).setFilename(filename).build());
            this.pluginCache.get(filename, hash, new SonarQubeServerPluginDownloader(key));
        }
        scanner.close();
        ProtobufUtil.writeToFile(builder.build(), dest.resolve("plugin_references.pb"));
    }

    private class SonarQubeServerPluginDownloader
    implements PluginCache.Downloader {
        private String key;

        SonarQubeServerPluginDownloader(String key) {
            this.key = key;
        }

        @Override
        public void download(String filename, Path toFile) throws IOException {
            String url = String.format("/deploy/plugins/%s/%s", this.key, filename);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Download plugin {} to {}", (Object)filename, (Object)toFile);
            } else {
                LOG.info("Download {}", (Object)filename);
            }
            CloseableWsResponse response = PluginReferencesDownloader.this.wsClient.get(url);
            try (InputStream stream = response.contentStream();){
                FileUtils.copyInputStreamToFile(stream, toFile.toFile());
            }
        }
    }
}

